/* $Header: TestNDM2NTriple.java 30-oct-2006.09:14:33 alwu Exp $ */

/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    alwu        10/30/06 - add NLS support
    alwu        06/02/06 - add function to allow dump rulesidx and multiple 
                           models 
    alwu        03/13/06 - A bit cleanup and merge description from MAIN 
    nalexand    08/04/05 - loadtest
    nalexand    07/25/05 - change package: rdf.client 
    nalexand    07/20/05 - add modelName for RDFM_modelName view output 
    nalexand    01/17/05 - testing
    nalexand    11/08/04 - nalexand_rdfjava0311
    nalexand    11/05/04 - Creation
 */

/**
 *  @version $Header: TestNDM2NTriple.java 30-oct-2006.09:14:33 alwu Exp $
 *  @author  nalexand
 *  @since   release specific (what release of product did this appear in)
 */

package oracle.spatial.rdf.client;
 
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;

/**
 * DESCRIPTION
 *  This class provides an example of how to convert an RDF model 
 *  stored in an Oracle RDF network, to a file in N-Triple format.
 *
 * NOTES
 *  In order to use the TestNDM2NTriple example the following requirements must be met:
 *  1) Must have an Oracle10g R2 database with Spatial installed
 *  3) Must have an RDF network with a model to be converted
 *  2) Must be the owner or have SELECT privileges on the RDF model, or be a privileged user 
 *  4) Must be using the following supplied Oracle10g R2 utilities and JDBC libraries (JARs):
 *      ojdbc14.jar, sdordf.jar
 *  5) Must have installed the Sun JDK version 1.4.2_04 or higher
 **/
public class TestNDM2NTriple 
{
  public TestNDM2NTriple()
  {
  }

  protected static OracleConnection m_conn;

  // some default values 
  private static String ms_szUser = "scott";
  private static String ms_szPass = "tiger";
  private static String ms_szHost = "127.0.0.1";
  private static String ms_szSid  = "orcl";
  private static String ms_szPort = "1521";

  static
  { 
    // database connection for testing using scott/tiger
    OracleConnection conn = null;

    String szVal = null;
    if ((szVal = System.getProperty("db.user")) != null) {
      ms_szUser = szVal;
    }

    if ((szVal = System.getProperty("db.password")) != null) {
      ms_szPass = szVal;
    }

    if ((szVal = System.getProperty("db.host")) != null) {
      ms_szHost = szVal;
    }

    if ((szVal = System.getProperty("db.sid")) != null) {
      ms_szSid = szVal;
    }

    if ((szVal = System.getProperty("db.port")) != null) {
      ms_szPort = szVal;
    }
    
    try { 
      DriverManager.registerDriver(new OracleDriver()) ;
      
      String szJdbcConn = "jdbc:oracle:thin:@" + ms_szHost + ":" +
          ms_szPort + ":" + ms_szSid;

      System.out.println( "Note: You can use JVM properties -Ddb.user=<user> "
                        + "-Ddb.password=<password> "
                        + "-Ddb.host=<host> -Ddb.sid=<sid> -Ddb.port=<port> to "
                        + "configure database connection.");

      System.out.println("");

      System.out.println("Connecting to " + szJdbcConn + " as user " + 
          ms_szUser);
      System.out.flush();

      conn = (OracleConnection)DriverManager.getConnection(
          szJdbcConn, ms_szUser, ms_szPass); 
    } 
    catch(SQLException e) { 
      e.printStackTrace();
    }

    m_conn = conn;
  }


    
  /**
   * Entry point.
   * @param args
   */
  public static void main(String[] args)
    throws SQLException, IOException
  {
    TestNDM2NTriple testNDM2NTriple = new TestNDM2NTriple();

    try{
      NTripleConverter.setConnection(m_conn);

      if (System.getProperty("charset") != null) {
        NTripleConverter.setEncoding(System.getProperty("charset"));
      }

      //
      //must be a privileged user to use 2 args
      if (args.length == 2) {
        String filename = args [0];
        int modelID = Integer.parseInt(args[1]);
        String modelName = new String();
        NTripleConverter.NDM2NTriple(filename, modelName, modelID);
      }
      else if (args.length >= 3) {
        String filename = args [0];

        if ("-models".equalsIgnoreCase(args[1])) {
          String secondLast = "";
          try {
            secondLast = args[args.length - 2];
          }
          catch (Throwable t) {
          }

          int numModels = args.length - 2;
          String indexName = null;
          if ("-index".equalsIgnoreCase(secondLast)) {
            numModels -= 2;
            indexName = args[args.length - 1];
            System.out.print( "\nrulesindex " + indexName);
          }
    
          String[] modelNames = new String[numModels];
          for (int idx = 0; idx < numModels; idx++) {
            modelNames[idx] = args[idx + 2];
            System.out.print( "\nmodel " + modelNames[idx]);
          } 

          NTripleConverter.NDM2NTriple(filename, modelNames, indexName);
        }
        else {
          String modelName = args [1];
          int modelID = Integer.parseInt(args[2]); 
          NTripleConverter.NDM2NTriple(filename, modelName, modelID);
        }
      } 
      else {
        System.err.println( "\nUsage " 
                          + "\n   java -Ddb.user=<user>  -Ddb.password=<password> "
                          + "-Ddb.host=<host> -Ddb.sid=<sid> -Ddb.port=<port>  "
                          + TestNDM2NTriple.class.getName() 
                          + " <NTripleFilename> ([<modelName> <modelID>] | [<modelID] ) "
                          + " \n");
        System.err.print( "\n   java -Ddb.user=<user>  -Ddb.password=<password> "
                          + "-Ddb.host=<host> -Ddb.sid=<sid> -Ddb.port=<port>  "
                          + TestNDM2NTriple.class.getName() 
                          + " <NTripleFilename> -models <modelName1> ... <modelNameN> [-index <rulesindexName>]"
                          + " \n");
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
